clc;clear;close all;
addpath('.\func'); 
addpath('.\rawdata'); 

%% Read raw SIM images
for i0 = 1:9
     Raw(:,:,i0) = imread('.\rawdata\Ours\Fixed\1\561_1.tif',i0);
end
WF9 = (sum(Raw,3)/9);
Rawt0 = importImages(Raw);                                                  % Edged pixel processing
[width, length, ill_num] = size(Rawt0);
reg=width;

%% Generate simulated PSF and OTF
param.size=[width width];                                             
Magn = 100;                                                                 % Magnification
param.micronsPerPixel=6.5/Magn;                                             % Pixel size
param.cyclesPerMicron=1/(param.size(1)*param.micronsPerPixel);
param.NA=1.4;                                                               % NA
param.lambda = 607;                                                         % Wavelength
param.imgSize = width;                                                 
param.cutoff=1000/(0.5*param.lambda/param.NA);
param.sampleLateral=ceil(param.cutoff/param.cyclesPerMicron)+1;        
param.nrBands=2;   
param.attStrength=0;
param.OtfProvider=SimOtfProvider(param,param.NA,param.lambda,1);   
PSF=abs(otf2psf((param.OtfProvider.otf)));                                  % PSF
OTF=param.OtfProvider.otf;                                                  % OTF
% figure;imshow(OTF,[],'border','tight');
% PSF=abs(otf2psf(OTF));

%% RL deconvolution
IIraw = deconvlucy(Rawt0,PSF,5); 
FRawt = zeros(size(IIraw));  
for i1 = 1:ill_num
    FRawt(:,:,i1) = fftshift(fft2(IIraw(:,:,i1)));
end
Rawt = IIraw;
Mask0 = zeros(width,width); Mask0(OTF ~= 0) = 1;

%% Illumination pattern extraction
[param,K,Friter,Plum_Mask] = Reserve_Fringe(Rawt,OTF,param); 
for i = 1:ill_num
    Rawt(:,:,i) = ifft2(ifftshift(Wiener_deconv2(FRawt(:,:,i).*Mask0,...
        OTF,0,0,0)));  
end
                                                                                       
%% Center-notched Hanning window
w_size = 2 * reg;
w=linspace(-pi,pi,w_size); wtick=[-1:0.5:1]; magtick=[0:0.5:1.1];
M=ceil(param.cutoff*2+1); n=0:M; x=0.5*(1-cos((2*pi*n)/M));                   
X=dtft(x,n,w); magX=abs(X); magX=magX/max(magX);
X2=dtft(x,n,w); magX2=abs(X2); magX2=magX2/max(magX2);
HanWin=magX'*magX2;
[NorFilter2, NorFilter]=NortchFilter(param); 
NotchWin=HanWin.*NorFilter2;

%% OTF for deconvolution
OTFi0=zeros(width*2,width*2);
OTFi = (twice_space(OTF));
OTFi0=OTFi;

%% Initial target estimation
OTFi_ini=twice_spectrum(OTF);
IRaw = zeros(2*width,2*width,ill_num); 
Frit = zeros(2*width,2*width,ill_num); 
for i = 1:ill_num
    Frit(:,:,i) = twice_space(Friter(:,:,i));
    IRaw(:,:,i) = twice_space(Rawt(:,:,i)); 
    Frit(:,:,i)=(ifft2(ifftshift((fftshift(fft2((Frit(:,:,i)))).*...
        conj(OTFi_ini)./(OTFi_ini.*conj(OTFi_ini)+0.01)))));  
end
Iobj=(ifft2(ifftshift((fftshift(fft2((IRaw(:,:,1)+IRaw(:,:,4)+...
    IRaw(:,:,7))./3)).*NotchWin))));        

%% Iteration
loop_num = 20;                                                              % Number of iteration cycles
for i5 = 1:loop_num 
        deI1=IRaw(:,:,1)./Frit(:,:,1)-(ifft2(ifftshift(OTFi0.*fftshift...
            (fft2(Iobj)))));       
        deI2=IRaw(:,:,4)./Frit(:,:,4)-(ifft2(ifftshift(OTFi0.*fftshift...
            (fft2(Iobj)))));    
        deI3=IRaw(:,:,7)./Frit(:,:,7)-(ifft2(ifftshift(OTFi0.*fftshift...
            (fft2(Iobj)))));   
        FdeI1=fftshift(fft2(deI1));
        FdeI2=fftshift(fft2(deI2));
        FdeI3=fftshift(fft2(deI3));    
        fftWiener=(ifft2(fftshift(((FdeI1.*conj(OTFi0)+FdeI2.*...
            conj(OTFi0)+FdeI3.*conj(OTFi0))./(OTFi0.*conj(OTFi0)+0.1)))));
        Iobj=Iobj+fftWiener;     
        Iobj(Iobj < 0) = 0;
spec=fftshift(fft2(Iobj));
spec = spec.*Plum_Mask;                                                     
Iobj = (ifft2(ifftshift(spec))); 
subplot(121);imshow(Iobj,[]);title('Updated target');
subplot(122);imshow(log(abs(spec)+1),[]);title(['Loop Num=',num2str(i5)]);
pause(0.000025);   
end

Iobj=abs(Iobj);
   Iobj = (Iobj) - min(min((Iobj)));

figure;imshow(twice_space(WF9)./max(max(WF9)).*255,[],'border','tight');
title('Wide-field');colormap hot;
figure;imshow(Iobj./max(max(Iobj)).*255,[],'border','tight');
title('Super-resolution');colormap hot;